/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.EditSinkPanelBean;
import com.ibm.hwmca.base.ntfy.EmailConfigPanelBean;
import com.ibm.hwmca.base.ntfy.EmailTemplatePanelBean;
import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.base.ntfy.SinkSubTasklet;
import com.ibm.hwmca.base.ntfy.SinksListPanelBean;
import com.ibm.hwmca.base.ntfy.SubstitutionVariablesPanelBean;
import com.ibm.hwmca.base.ntfy.TemplateManagerPanelBean;
import com.ibm.hwmca.base.ntfy.TimeManagerPanelBean;
import com.ibm.hwmca.base.ntfy.UserManagerPanelBean;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.AbstractSink;
import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.EmailSink;
import com.ibm.hwmca.fw.ntfy.EmailTemplate;
import com.ibm.hwmca.fw.ntfy.FilterList;
import com.ibm.hwmca.fw.ntfy.MonitoredHashMap;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.ntfy.TimeFilter;
import com.ibm.hwmca.fw.ntfy.UserObject;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class EmailTasklet
extends SinkSubTasklet {
    private static final String TRACE_MASKT = "XNTYEMTT";
    private static final String TRACE_MASKF = "XNTYEMTF";
    private static final String TRACE_MASKD = "XNTYEMTD";

    LocalizableText getTabName() {
        return new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.tab.email");
    }

    String getSinkKeyName() {
        return "com.ibm.hwmca.fw.ntfy.EmailSink";
    }

    EmailSink buildSink(String sinkName, String sinkDesc, FilterList filterList, Map usersMap) {
        return new EmailSink(sinkName, sinkDesc, filterList, usersMap);
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String command;
        Trace.trace(TRACE_MASKT, "<> EmailTasklet.service()");
        super.service(request, response);
        String source = (String)request.getData("CommandSource");
        if (source == null) {
            source = "";
        }
        if ((command = (String)request.getData("CommandName")) == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (!(request.isCanceled() || request.isDisposed() || command.equals("") || command.equals("CANCEL"))) {
            if (source.equals("ConfigButton")) {
                this.serviceConfigPanel(request, response);
            } else if (source.equals("EditSinkPanel")) {
                this.serviceEditSinkPanel(request, response);
            } else if (source.equals("EmailTemplatePanel")) {
                this.serviceEmailTemplatePanel(request, response);
            } else if (source.equals("UserManagerPanel")) {
                this.serviceUserManagerPanel(request, response);
            } else if (source.equals("TimeManagerPanel")) {
                this.serviceTimeManagerPanel(request, response);
            } else if (source.equals("TemplateManagerPanel")) {
                this.serviceTemplateManagerPanel(request, response);
            } else if (source.equals("SinksListPanel")) {
                this.serviceSinksListPanel(request, response);
            } else if (command.equals("BounceCommand")) {
                this.serviceBounce(request, response);
            } else {
                this.unknownCommand(response, command);
            }
        }
    }

    private final void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> serviceInitial()");
        this.errorId = (short)-32749;
        SinksListPanelBean bean = new SinksListPanelBean();
        bean.setBeanName("SinksListPanel" + this.getTabName());
        bean.setDisplayableBeanName(this.getTabName());
        HashMap beanData = new HashMap();
        TreeMap allSinks = new TreeMap();
        Map sinks = NotificationService.getManager().getSinksWithClassName(this.getSinkKeyName());
        Iterator iterator = sinks.keySet().iterator();
        while (iterator.hasNext()) {
            String sinkName = (String)iterator.next();
            HashMap<String, Object> sinkMap = new HashMap<String, Object>();
            AbstractSink sink = (AbstractSink)sinks.get(sinkName);
            sinkMap.put("DataMapSinkName", sinkName);
            sinkMap.put("DataMapSinkDescription", sink.getDescription());
            sinkMap.put("DataMapSinkEnabled", new Boolean(sink.isEnabled()));
            EmailTemplate emailTemplate = ((EmailSink)sink).getTemplate();
            if (emailTemplate != null) {
                sinkMap.put("DataMapTemplateName", emailTemplate.getName());
            } else {
                sinkMap.put("DataMapTemplateName", "");
            }
            Map users = sink.getUsers();
            String[] userList = new String[users.size()];
            int i = 0;
            Iterator userIterator = users.keySet().iterator();
            while (userIterator.hasNext()) {
                userList[i] = (String)userIterator.next();
                ++i;
            }
            sinkMap.put("DataMapUsersTable", userList);
            allSinks.put(sinkName, sinkMap);
        }
        beanData.put("SinksListTable", allSinks);
        bean.setData(beanData);
        response.replace("com.ibm.hwmca.base.ntfy.res.NotificationRes", "SinksListPanel", bean);
    }

    void serviceConfigPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceConfigPanel");
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("OKButton")) {
            this.setConfigData((Serializable)request.getData("TaskletDataMap"));
            Map map = (Map)request.getData("TaskletDataMap");
            NotificationService.getManager().getGlobalProperties().remove("smtpserver");
            NotificationService.getManager().getGlobalProperties().remove("smtpport");
            NotificationService.getManager().getGlobalProperties().put("smtpserver", map.get("DataMapHost"));
            NotificationService.getManager().getGlobalProperties().put("smtpport", map.get("DataMapPort"));
            this.serviceDisposed(request, response);
        } else if (command.equals("CancelButton")) {
            this.serviceDisposed(request, response);
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceEditSinkPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceEditSinkPanel");
        this.errorId = (short)-32764;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("TemplateButton")) {
            TemplateManagerPanelBean bean = new TemplateManagerPanelBean();
            bean.setBeanName("TemplateManagerPanel");
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map templates = null;
            templates = NotificationService.getManager().getEmailTemplates();
            Map[] templatesMap = new Map[templates.size()];
            int i = 0;
            ArrayList templateNames = new ArrayList(templates.keySet());
            Collections.sort(templateNames);
            Iterator iterator = templateNames.iterator();
            while (iterator.hasNext()) {
                String nextTemplate = (String)iterator.next();
                EmailTemplate template = (EmailTemplate)templates.get(nextTemplate);
                templatesMap[i] = new HashMap();
                templatesMap[i].put("DataMapName", nextTemplate);
                templatesMap[i].put("DataMapDesc", template.getDescription());
                ++i;
            }
            map.put("TemplateTable", templatesMap);
            map.put("TaskletSelectedTemplate", request.getData("DataMapTemplateName"));
            bean.setData(map);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "TemplateManagerPanel", bean);
        } else if (command.equals("UsersButton")) {
            UserManagerPanelBean bean = new UserManagerPanelBean();
            bean.setBeanName("UserManagerPanel");
            Map users = NotificationService.getManager().getUsers();
            Map[] userMaps = new Map[users.size()];
            ArrayList userNames = new ArrayList(users.keySet());
            Collections.sort(userNames);
            int i = 0;
            Iterator iterator = userNames.iterator();
            while (iterator.hasNext()) {
                String userName = (String)iterator.next();
                UserObject user = (UserObject)users.get(userName);
                userMaps[i] = new HashMap();
                userMaps[i].put("DataMapUserName", user.getName());
                userMaps[i].put("DataMapFullName", user.getDescription());
                userMaps[i].put("DataMapEnabled", new Boolean(user.isEnabled()));
                userMaps[i].put("DataMapOtherNotes", user.getAttribute("com.ibm.hwmca.base.ntfy.UserManagerTasklet"));
                ++i;
            }
            HashMap<String, Object> beanData = new HashMap<String, Object>();
            beanData.put("UserTable", userMaps);
            beanData.put("EditMode", Boolean.FALSE);
            beanData.put("TaskletSelectedUser", request.getData("DataMapUsersTable"));
            bean.setData(beanData);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "UserManagerPanel", bean);
        } else if (command.equals("TimesButton")) {
            TimeManagerPanelBean bean = new TimeManagerPanelBean();
            bean.setBeanName("TimeManagerPanel");
            TreeMap times = new TreeMap();
            Map filters = NotificationService.getManager().getFilters();
            Iterator iterator = filters.keySet().iterator();
            while (iterator.hasNext()) {
                String filterName = (String)iterator.next();
                if (!(filters.get(filterName) instanceof TimeFilter)) continue;
                times.put(filterName, filters.get(filterName));
            }
            Map[] timeMaps = new Map[times.size()];
            int i = 0;
            Iterator iterator2 = times.keySet().iterator();
            while (iterator2.hasNext()) {
                String timeName = (String)iterator2.next();
                TimeFilter time = (TimeFilter)times.get(timeName);
                timeMaps[i] = new HashMap();
                timeMaps[i].put("DataMapUserName", time.getName());
                timeMaps[i].put("DataMapDesc", time.getDescription());
                ++i;
            }
            HashMap<String, Object> beanData = new HashMap<String, Object>();
            beanData.put("TimeTable", timeMaps);
            beanData.put("EditMode", Boolean.FALSE);
            beanData.put("TaskletSelectedTimes", request.getData("DataMapTimesTable"));
            bean.setData(beanData);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "TimeManagerPanel", bean);
        } else if (command.equals("OKButton")) {
            Map data = (Map)request.getData("TaskletSinkDataMap");
            HashMap<String, Object> updateData = new HashMap<String, Object>();
            if (this.mode == 1) {
                updateData.put("CommandName", "AddButton");
                updateData.put("AddButton", data);
            } else if (this.mode == 2) {
                updateData.put("CommandName", "EditButton");
                updateData.put("EditButton", data);
            }
            String sinkName = (String)data.get("DataMapSinkName");
            String sinkDesc = (String)data.get("DataMapSinkDescription");
            Boolean enabled = (Boolean)data.get("DataMapSinkEnabled");
            String[] users = (String[])data.get("DataMapUsersTable");
            if (users == null) {
                users = new String[]{};
            }
            String templateName = (String)data.get("DataMapTemplateName");
            String[] times = (String[])data.get("DataMapTimesTable");
            if (times == null) {
                times = new String[]{};
            }
            EmailTemplate template = null;
            try {
                template = (EmailTemplate)NotificationService.getManager().getEmailTemplates().get(templateName);
                Trace.trace(TRACE_MASKF, "serviceEditSinkPanel:  " + template);
                Trace.trace(TRACE_MASKF, "serviceEditSinkPanel:  template name is " + templateName);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                HashMap<String, DescriptiveObject> usersMap = new HashMap<String, DescriptiveObject>();
                int i = 0;
                while (i < users.length) {
                    DescriptiveObject user = (DescriptiveObject)NotificationService.getManager().getUsers().get(users[i]);
                    usersMap.put(users[i], user);
                    ++i;
                }
                FilterList filterList = new FilterList(sinkName, sinkDesc);
                int i2 = 0;
                while (i2 < times.length) {
                    filterList.add((TimeFilter)NotificationService.getManager().getFilters().get(times[i2]));
                    ++i2;
                }
                EmailSink sink = this.buildSink(sinkName, sinkDesc, filterList, usersMap);
                sink.setEnabled(enabled);
                if (this.mode == 2) {
                    ((MonitoredHashMap)NotificationService.getManager().getSinks()).replace(sinkName, sink);
                } else {
                    NotificationService.getManager().getSinks().put(sinkName, sink);
                }
                sink.setTemplate(template);
                if (sink instanceof Startable) {
                    try {
                        ((Startable)((Object)sink)).start();
                    }
                    catch (Exception e) {
                        new FrameworkLog(NotificationErrorIds._logInfo, -32737, e).log(LogAttributes.INFO_LOG);
                    }
                }
                response.dispose("EditSinkPanel");
                this.bounceUpdate("SinksListPanel" + this.getTabName(), updateData);
            }
            catch (DuplicateNameException dne) {
                this.duplicateMessage(sinkName);
                response.noAction();
            }
        } else if (command.equals("CancelButton")) {
            response.dispose("EditSinkPanel");
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceEmailTemplatePanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block14: {
            Trace.trace(TRACE_MASKT, "<> serviceEmailTemplatePanel");
            this.errorId = (short)-32760;
            String command = (String)request.getData("CommandName");
            if (command == null) {
                command = "";
            }
            if (command.equals("OKButton") || command.equals("ApplyButton")) {
                String startName = (String)request.getData("DataMapStartName");
                String name = (String)request.getData("DataMapName");
                EmailTemplate template = null;
                try {
                    template = new EmailTemplate((String)request.getData("DataMapName"), (String)request.getData("DataMapDesc"), (String)request.getData("DataMapTo"), (String)request.getData("DataMapFrom"), (String)request.getData("DataMapSubject"), (String)request.getData("DataMapMessage"));
                    MonitoredHashMap emailTemplates = (MonitoredHashMap)NotificationService.getManager().getEmailTemplates();
                    if (startName.equals(name)) {
                        emailTemplates.replace(name, template);
                    } else {
                        emailTemplates.put(name, template);
                    }
                    if (command.equals("OKButton")) {
                        HashMap<String, Object> updateData = new HashMap<String, Object>();
                        String s = (String)NotificationService.getManager().getGlobalProperties().get("advanced");
                        if (startName.equals(name)) {
                            updateData.put("CommandName", "EditButton");
                        } else {
                            updateData.put("CommandName", "AddButton");
                        }
                        updateData.put("DataMapName", name);
                        updateData.put("DataMapDesc", request.getData("DataMapDesc"));
                        response.dispose("EmailTemplatePanel");
                        this.bounceUpdate("TemplateManagerPanel", updateData);
                        break block14;
                    }
                    response.noAction();
                }
                catch (DuplicateNameException dne) {
                    this.duplicateMessage(name);
                    response.noAction();
                }
            } else if (command.equals("CancelButton")) {
                response.dispose("EmailTemplatePanel");
            } else if (command.equals("SubstVarsButton")) {
                SubstitutionVariablesPanelBean bean = new SubstitutionVariablesPanelBean();
                bean.setBeanName("SubstitutionVariablesPanel");
                HashMap<String, String> beanData = new HashMap<String, String>();
                beanData.put("DataMapLaunchingTasklet", this.getClass().getName());
                bean.setData(beanData);
                response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "SubstitutionVariablesPanel", bean);
            } else {
                this.unknownCommand(response, command);
            }
        }
    }

    void serviceTemplateManagerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceTemplateManagerPanel");
        this.errorId = (short)-32745;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("OKButton")) {
            response.dispose("TemplateManagerPanel");
            HashMap<String, Object> updateData = new HashMap<String, Object>();
            updateData.put("CommandName", "TemplateButton");
            updateData.put("TemplateButton", request.getData("TaskletSelectedTemplate"));
            this.bounceUpdate("EditSinkPanel", updateData);
        } else if (command.equals("AddButton")) {
            EmailTemplatePanelBean bean = new EmailTemplatePanelBean();
            bean.setBeanName("EmailTemplatePanel");
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EmailTemplatePanel", bean);
        } else if (command.equals("EditButton")) {
            EmailTemplatePanelBean bean = new EmailTemplatePanelBean();
            bean.setBeanName("EmailTemplatePanel");
            HashMap<String, String> beanData = new HashMap<String, String>();
            String templateName = (String)request.getData("TaskletSelectedTemplate");
            EmailTemplate template = null;
            template = (EmailTemplate)NotificationService.getManager().getEmailTemplates().get(templateName);
            if (template != null) {
                beanData.put("DataMapName", template.getName());
                beanData.put("DataMapDesc", template.getDescription());
                beanData.put("DataMapTo", template._to);
                beanData.put("DataMapFrom", template._from);
                beanData.put("DataMapSubject", template._subject);
                beanData.put("DataMapMessage", template._message);
            } else {
                beanData.put("DataMapName", templateName);
            }
            bean.setData(beanData);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EmailTemplatePanel", bean);
        } else if (command.equals("DeleteButton")) {
            String templateName = (String)request.getData("TaskletSelectedTemplate");
            if (this.okToDelete(templateName)) {
                Object template = null;
                NotificationService.getManager().getEmailTemplates().remove(templateName);
                HashMap<String, String> updateData = new HashMap<String, String>();
                updateData.put("CommandName", "DeleteButton");
                response.update("TemplateManagerPanel", updateData);
            } else {
                response.noAction();
            }
        }
    }

    void serviceUserManagerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceUserManagerPanel");
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        this.errorId = (short)-32743;
        if (command.equals("OKButton")) {
            String[] users = (String[])request.getData("TaskletSelectedUser");
            response.dispose("UserManagerPanel");
            HashMap<String, Object> updateData = new HashMap<String, Object>();
            updateData.put("CommandName", "UsersButton");
            updateData.put("UsersButton", users);
            this.bounceUpdate("EditSinkPanel", updateData);
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceTimeManagerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceUserManagerPanel");
        this.errorId = (short)-32741;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("OKButton")) {
            String[] times = (String[])request.getData("TaskletSelectedTimes");
            response.dispose("TimeManagerPanel");
            HashMap<String, Object> updateData = new HashMap<String, Object>();
            updateData.put("CommandName", "TimesButton");
            updateData.put("TimesButton", times);
            this.bounceUpdate("EditSinkPanel", updateData);
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceSinksListPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceSinksListPanel");
        this.errorId = (short)-32749;
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (command.equals("AddButton")) {
            this.mode = 1;
            EditSinkPanelBean bean = new EditSinkPanelBean();
            bean.setBeanName("EditSinkPanel");
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditSinkPanel", bean);
        } else if (command.equals("EditButton")) {
            this.mode = 2;
            EditSinkPanelBean bean = new EditSinkPanelBean();
            bean.setBeanName("EditSinkPanel");
            String sinkName = (String)request.getData("TaskletSelectedSink");
            AbstractSink sink = (AbstractSink)NotificationService.getManager().getSinks().get(sinkName);
            HashMap<String, Object> beanData = new HashMap<String, Object>();
            beanData.put("DataMapSinkName", sinkName);
            beanData.put("DataMapSinkDescription", sink.getDescription());
            EmailTemplate emailTemplate = ((EmailSink)sink).getTemplate();
            if (emailTemplate != null) {
                beanData.put("DataMapTemplateName", emailTemplate.getName());
            } else {
                beanData.put("DataMapTemplateName", "");
            }
            beanData.put("DataMapSinkEnabled", new Boolean(sink.isEnabled()));
            Map users = sink.getUsers();
            String[] userNames = new String[users.size()];
            int i = 0;
            Iterator iterator = users.keySet().iterator();
            while (iterator.hasNext()) {
                userNames[i] = (String)iterator.next();
                ++i;
            }
            beanData.put("DataMapUsersTable", userNames);
            i = 0;
            FilterList filterList = sink.getFilters();
            String[] filters = new String[filterList.size()];
            Iterator filterIterator = filterList.iterator();
            while (filterIterator.hasNext()) {
                filters[i] = ((DescriptiveObject)filterIterator.next()).getName();
                ++i;
            }
            beanData.put("DataMapTimesTable", filters);
            bean.setData(beanData);
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditSinkPanel", bean);
        } else if (command.equals("DeleteButton")) {
            String sinkName = (String)request.getData("TaskletSelectedSink");
            if (this.okToDelete(sinkName)) {
                AbstractSink sink = (AbstractSink)NotificationService.getManager().getSinks().get(sinkName);
                if (sink instanceof Startable) {
                    try {
                        ((Startable)((Object)sink)).stop();
                    }
                    catch (Exception e) {
                        new FrameworkLog(NotificationErrorIds._logInfo, -32736, e).log(LogAttributes.INFO_LOG);
                    }
                }
                NotificationService.getManager().getSinks().remove(sinkName);
                HashMap<String, String> updateData = new HashMap<String, String>();
                updateData.put("CommandName", "DeleteButton");
                updateData.put("DeleteButton", sinkName);
                response.update("SinksListPanel" + this.getTabName(), updateData);
            } else {
                response.noAction();
            }
        } else if (command.equals("ConfigButton")) {
            EmailConfigPanelBean bean = new EmailConfigPanelBean();
            bean.setBeanName("EmailConfigPanel");
            bean.setData((Map)((Object)this.getConfigData()));
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EmailConfigPanel", bean);
        } else {
            this.unknownCommand(response, command);
        }
    }
}

